<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

use StemBase\Modules\Shortcodes\Shortcode\ShortcodeBase;

class Image extends ShortcodeBase {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = "image";
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = "1.0";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $help = "";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_usage = "[image src=\"path_to_image\"]\n[image src=\"path_to_image\"  lightbox=\"true\" lightbox_image=\"path_to_resource\"]";

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_attributes = array(
		array(
			"name"		=> "src",
			"hint"		=> "path to image source, can be local or absolute"
		),

		array(
			"name"		=> "style",
			"hint"		=> "none|dropshadow|bottomshadow, default: none"
		),

		array(
			"name"		=> "copyright",
			"hint"		=> "author of image, default: empty"
		),

		array(
			"name"		=> "border",
			"hint"		=> "#hexcode|yes, default: transparent"
		),

		array(
			"name"		=> "border_size",
			"hint"		=> "value in px, default: skin default"
		),

		array(
			"name"		=> "radius",
			"hint"		=> "square|round|corners, default: square",			
		),

		array(
			"name"		=> "hover",
			"hint"		=> "yes|no|zoomin|zoomout, default: yes"
		),

		array(
			"name"		=> "align",
			"hint"		=> "left|right|center, default: none"
		),

		array(
			"name"		=> "width",
			"hint"		=> "value in px, default: auto"
		),

		array(
			"name"		=> "title",
			"hint"		=> "custom alternative text. Will appear in lightbox as title if set."
		),

		array(
			"name"		=> "lightbox",
			"hint"		=> "yes|no, default: no"
		),

		array(
			"name"		=> "lightbox_image",
			"hint"		=> "path to resource to be opened in lightbox, can be image, local video, youtube, vimeo."
		),

		array(
			"name"		=> "link",
			"hint"		=> "link to open on click, it will disable lightbox if enabled"
		),

		array(
			"name"		=> "rel",
			"hint"		=> "index|noindex|follow|nofollow, default: none"
		),

		array(
			"name"		=> "target",
			"hint"		=> "none|_blank, default: none"
		),
		array(
			"name"		=> "class",
			"hint"		=> "custom css class to the wrapping element for future customization"
		),		
	);

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($data) {

		$this->loadTemplate();

		$vars = $data["vars"];

		$info = array(
			"icon_zoom"	=> "icomoon icon-search2",
			"icon_link"	=> "icomoon icon-link",

			"_content"	=> "",

			"alt"		=> $vars["title"],
			"title"		=> $vars["title"],
		);


		$css = array();
		$style = array();

		if ($data["vars"]["class"]) { $css[] = $data["vars"]["class"]; }

		if ($data["vars"]["width"]) { $style[] = "width: " . $this->getSize($data["vars"]["width"]); }

		if ($data["vars"]["copyright"]) {

			$copyright = $this->tpl->blockReplace(
				$data["vars"]["copyright_link"] ? "CopyrightLink" : "Copyright",
				array(
					"copyright"	=> $data["vars"]["copyright"],
				)
			);
		}

		if ($vars["lightbox"]) {
			$info["_content"] = $this->tpl->blockReplace(
				"LightBox",
				array(
					"source"	=> $vars["lightbox_image"] ? $vars["lightbox_image"] : $vars["src"] ,
					"tn"		=> $vars["src"],
					"_link"		=> $vars["link"] ? $this->tpl->blockReplace(
						"LightBoxLink",
						array(
							"link"		=> $vars["link"],
							"target"	=> $vars["target"],
							"rel"		=> $vars["rel"],
							"icon"		=> $info["icon_link"]
						)
					) : "",
				),
				$info
			);
		}

		if ($vars["link"]) {
			$info["_content"] = $this->tpl->blockReplace(
				"Link",
				array(
					"link"		=> $vars["link"],
					"target"	=> $vars["target"],
					"rel"		=> $vars["rel"],
					"icon"		=> $info["icon_link"]
				)
			) ;
		}
		


		switch ($vars["style"]) {
			case "dropshadow":
				$css[] = "dropshadow";
			break;

			case "bottomshadow":
				$css[] = "bottomshadow";
			break;

		}
		
		switch ($vars["radius"]) {
			case "round":	$css[] = "round"; break;
			case "corners":	$css[] = "corners"; break;
		}

		switch ($vars["align"]) {
//			default:		$css[] = "center"; break;
			case "center":	$css[] = "center"; break;
			case "left":	$css[] = "left"; break;
			case "right":	$css[] = "right"; break;
		}

		switch ($vars["hover"]) {
			case "no":		$css[] = "no-hover"; break;
			case "zoomin":	$css[] = "zoomin"; break;
			case "zoomout":	$css[] = "zoomout"; break;
		}


		if ($vars["border"]) {

			$css[] = "bordered";

			if ($vars["border"] != "yes") {
				$style[] = $this->getBackground($vars["border"] , "border-color")["bg_style"];
			}

			if ($vars["border_size"]) {
				$style[] = "border-width: " . $vars["border_size"] . "px;";
			}

			
		}
	
		

		return array(
			"content"	=> $this->tpl->blockReplace(
				"Main",
				array(
					"src"		=> $data["vars"]["src"],

					"css"		=> implode(" " , $css),
					"style"		=> implode(" " , $style),

					"_copy"		=> $copyright,
					
					"_title"	=> $data["vars"]["title"] ? $this->tpl->blockReplace(
						"Title",
						array(
							"title"	=> $data["vars"]["title"]
						)
					) : ""
				),
				$info,
				$this->getBackground($data["vars"]["bg"])
			),
			"before"	=> "",
			"after"		=> "",
		);

		//debug($data,1);
	}

}